<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Shield\ActionRouter\Actions\Render\Components\Scans\Results;

use FernleafSystems\Wordpress\Plugin\Shield\Tables\DataTables\Build\Scans\ForMalware;
use FernleafSystems\Wordpress\Services\Services;

class Malware extends Base {

	public const SLUG = 'scanresults_malware';
	public const TEMPLATE = '/wpadmin_pages/insights/scans/results/section/malware/index.twig';

	protected function getRenderData() :array {
		$con = self::con();

		$data = $this->buildMalwareData();
		return Services::DataManipulation()->mergeArraysRecursive( parent::getRenderData(), [
			'strings' => [
				'no_files'       => __( "Previous scans didn't detect any files suspected of being malware.", 'wp-simple-firewall' ),
				'files_found'    => __( "Previous scans detected 1 or more files suspected of being malware.", 'wp-simple-firewall' ),
				'mal_restricted' => __( 'Scanning for PHP Malware is only available with ShieldPRO.', 'wp-simple-firewall' ),
			],
			'flags'   => [
				'mal_is_restricted' => !$con->isPremiumActive(),
			],
			'vars'    => [
				'count_items'     => $data[ 'vars' ][ 'count_items' ],
				'malware'         => $data,
				'datatables_init' => ( new ForMalware() )->build(),
				'beacon_help_id'  => 443
			]
		] );
	}

	private function buildMalwareData() :array {
		$mod = self::con()->getModule_HackGuard();
		$count = $mod->getScansCon()
					 ->getScanResultsCount()
					 ->countMalware();
		$data = [
			'flags' => [
				'has_malware' => $count > 0,
			],
			'vars'  => [
				'count_items' => $count
			]
		];
		$data[ 'flags' ][ 'has_issue' ] = $data[ 'flags' ][ 'has_malware' ];
		return $data;
	}
}